/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.efmextra.skills.SAO;

import com.dfdyz.epicacg.efmextra.skills.EpicACGSkillSlot;
import com.dfdyz.epicacg.efmextra.skills.IMutiSpecialSkill;
import com.dfdyz.epicacg.efmextra.skills.MultiSpecialSkill;
import com.dfdyz.epicacg.efmextra.skills.SimpleWeaponSASkill;
import com.dfdyz.epicacg.registry.MyAnimations;
import com.dfdyz.epicacg.registry.MySkillDataKeys;
import com.dfdyz.epicacg.registry.MySkills;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.AttackAnimationProvider;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.SimpleWeaponInnateSkill;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SingleSwordSASkills
extends SimpleWeaponSASkill
implements IMutiSpecialSkill {
    private final ArrayList<ResourceLocation> noPower = new ArrayList();
    private final ArrayList<ResourceLocation> morePower = new ArrayList();
    private final UUID EventUUID = UUID.fromString("eb69decf-48a1-5333-dacc-884fd345c02a");
    private final AttackAnimationProvider noPowerAnimation1 = () -> (AttackAnimation)Animations.SWEEPING_EDGE;
    private final AttackAnimationProvider morePowerAnimation1 = () -> (AttackAnimation)MyAnimations.DMC5_V_JC;

    public SingleSwordSASkills(SimpleWeaponInnateSkill.Builder builder) {
        super(builder);
        ResourceLocation name = this.getRegistryName();
        this.noPower.add(new ResourceLocation(name.m_135827_(), "textures/gui/skills/" + name.m_135815_() + ".png"));
        this.noPower.add(new ResourceLocation(name.m_135827_(), "textures/gui/skills/single/judgement_cut.png"));
    }

    public static SimpleWeaponInnateSkill.Builder createBuilder(ResourceLocation resourceLocation) {
        return (SimpleWeaponInnateSkill.Builder)new SimpleWeaponInnateSkill.Builder().setCategory((SkillCategory)SkillCategories.WEAPON_INNATE).setActivateType(Skill.ActivateType.ONE_SHOT).setRegistryName(resourceLocation).setResource(Skill.Resource.WEAPON_CHARGE);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getSkillCapability().skillContainers[EpicACGSkillSlot.SKILL_SELECTOR.universalOrdinal()].setSkill(MySkills.MUTI_SPECIAL_ATTACK);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, this.EventUUID, e -> {
            boolean inv;
            PlayerPatch playerPatch = e.getPlayerPatch();
            SkillContainer sc = playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
            if (sc != null && (inv = ((Boolean)sc.getDataManager().getDataValue((SkillDataKey)MySkillDataKeys.JCE_Invincible.get())).booleanValue())) {
                e.setResult(AttackResult.ResultType.BLOCKED);
                e.setCanceled(true);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getDataManager().setData((SkillDataKey)MySkillDataKeys.JCE_Invincible.get(), (Object)false);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, this.EventUUID);
    }

    public boolean checkExecuteCondition(PlayerPatch<?> executer) {
        SkillContainer skillContainer = executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        int selected = (Integer)executer.getSkill((SkillSlot)EpicACGSkillSlot.SKILL_SELECTOR).getDataManager().getDataValue((SkillDataKey)MySkillDataKeys.CHILD_SKILL_INDEX.get());
        boolean ok = skillContainer.getStack() >= (selected == 0 ? 1 : 5);
        return ok || ((Player)executer.getOriginal()).m_7500_();
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        int selected = MultiSpecialSkill.getSelected((PlayerPatch)executer);
        if (selected == 0) {
            executer.playAnimationSynchronized((StaticAnimation)this.noPowerAnimation1.get(), 0.0f);
            this.setStackSynchronize(executer, executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getStack() - 1);
        } else {
            executer.playAnimationSynchronized((StaticAnimation)this.morePowerAnimation1.get(), 0.0f);
            this.setStackSynchronize(executer, executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getStack() - 5);
        }
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    @Override
    public ArrayList<ResourceLocation> getSkillTextures(PlayerPatch<?> executer) {
        return this.noPower;
    }

    @Override
    public boolean isSkillActive(PlayerPatch<?> executer, int idx) {
        if (((Player)executer.getOriginal()).m_7500_()) {
            return true;
        }
        if (idx == 0) {
            return true;
        }
        return idx == 1 && executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getStack() >= 5;
    }
}

